#pragma once

#include <Windows.h>
#include <string>
#include <vector>
#include "../SQLite 3.7.17/sqlite3.h"	// ʹsqlite3Ҫͷļ

#pragma comment(lib, "sqlite3.lib")

#if defined(UNICODE) || defined(_UNICODE)
	typedef std::wstring tstring;
#else
	typedef std::string tstring;
#endif

struct BUDDY_MSG_LOG		// Ϣ¼
{
	UINT nID;
	UINT nQQNum;
	tstring strNickName;
	UINT nTime;
	BOOL bSendFlag;
	tstring strContent;
};

struct GROUP_MSG_LOG		// ȺϢ¼
{
	UINT nID;
	UINT nGroupNum;
	UINT nQQNum;
	tstring strNickName;
	UINT nTime;
	tstring strContent;
};

struct SESS_MSG_LOG			// ʱỰ(ȺԱ)Ϣ¼
{
	UINT nID;
	UINT nQQNum;
	tstring strNickName;
	UINT nTime;
	BOOL bSendFlag;
	tstring strContent;
};

void CloneStr(const wchar_t * src, wchar_t ** dest, UINT * destlen);

class CMessageLogger
{
public:
	CMessageLogger(void);
	~CMessageLogger(void);

public:
	tstring GetMsgLogFileName();						// ȡϢ¼ļ
	void SetMsgLogFileName(LPCTSTR lpszFileName);		// Ϣ¼ļ

	BOOL IsMsgLogFileValid();							// жϢ¼ļǷЧ
	BOOL CreateMsgLogFile();							// Ϣ¼ļ

	BOOL WriteBuddyMsgLog(UINT nQQNum, LPCTSTR lpNickName,	// дһϢ¼
		UINT nTime, BOOL bSendFlag, LPCTSTR lpContent);
	BOOL WriteGroupMsgLog(UINT nGroupNum, UINT nQQNum,		// дһȺϢ¼
		LPCTSTR lpNickName, UINT nTime, LPCTSTR lpContent);
	BOOL WriteSessMsgLog(UINT nQQNum, LPCTSTR lpNickName,	// дһʱỰ(ȺԱ)Ϣ¼
		UINT nTime, BOOL bSendFlag, LPCTSTR lpContent);

	BOOL WriteBuddyMsgLog(BUDDY_MSG_LOG * lpMsgLog);	// дһϢ¼
	BOOL WriteGroupMsgLog(GROUP_MSG_LOG * lpMsgLog);	// дһȺϢ¼
	BOOL WriteSessMsgLog(SESS_MSG_LOG * lpMsgLog);		// дһʱỰ(ȺԱ)Ϣ¼

	UINT ReadBuddyMsgLog(UINT nQQNum, UINT nOffset,		// һϢ¼
		UINT nRows, std::vector<BUDDY_MSG_LOG *>& arrMsgLog);
	UINT ReadGroupMsgLog(UINT nGroupNum, UINT nOffset,	// һȺϢ¼
		UINT nRows, std::vector<GROUP_MSG_LOG *>& arrMsgLog);
	UINT ReadSessMsgLog(UINT nQQNum, UINT nOffset,		// һʱỰ(ȺԱ)Ϣ¼
		UINT nRows, std::vector<SESS_MSG_LOG *>& arrMsgLog);

	UINT GetBuddyMsgLogCount(UINT nQQNum);				// ȡϢ¼
	UINT GetGroupMsgLogCount(UINT nGroupNum);			// ȡȺϢ¼
	UINT GetSessMsgLogCount(UINT nQQNum);				// ȡʱỰ(ȺԱ)Ϣ¼

	BOOL DelAllBuddyMsgLog();							// ɾкϢ¼
	BOOL DelAllGroupMsgLog();							// ɾȺϢ¼
	BOOL DelAllSessMsgLog();							// ɾʱỰ(ȺԱ)Ϣ¼

	BOOL DelBuddyMsgLog(UINT nQQNum);					// ɾָѵϢ¼
	BOOL DelGroupMsgLog(UINT nGroupNum);				// ɾָȺϢ¼
	BOOL DelSessMsgLog(UINT nQQNum);					// ɾָʱỰ(ȺԱ)Ϣ¼

	BOOL DelBuddyMsgLogByID(UINT nID);					// ɾָIDĺϢ¼
	BOOL DelGroupMsgLogByID(UINT nID);					// ɾָIDȺϢ¼
	BOOL DelSessMsgLogByID(UINT nID);					// ɾָIDʱỰ(ȺԱ)Ϣ¼

	void Lock();										// 
	void UnLock();										// 

	// ӽӿڣ
	// 1ĳʱ䡢ָݶϢ¼
	// 2ĳʱɾϢ¼

private:
	UINT ReadBuddyMsgLogCount(UINT nQQNum, UINT nOffset, UINT nRows);
	UINT ReadGroupMsgLogCount(UINT nGroupNum, UINT nOffset, UINT nRows);
	UINT ReadSessMsgLogCount(UINT nQQNum, UINT nOffset, UINT nRows);

	void Replace(tstring& strText, const TCHAR * lpOldStr, const TCHAR * lpNewStr);

private:
	tstring m_strFileName;
	HANDLE m_hMutex;
};
